/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.impl.atlas.network.packet.s2c.play;

import dev.architectury.networking.NetworkManager;
import hunternif.mc.impl.atlas.AntiqueAtlasMod;
import hunternif.mc.impl.atlas.core.AtlasData;
import hunternif.mc.impl.atlas.core.TileGroup;
import hunternif.mc.impl.atlas.core.WorldData;
import hunternif.mc.impl.atlas.network.packet.s2c.S2CPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileGroupsS2CPacket
extends S2CPacket {
    public static final int TILE_GROUPS_PER_PACKET = 100;
    public static final ResourceLocation ID = AntiqueAtlasMod.id("packet", "s2c", "tile", "groups");

    public TileGroupsS2CPacket(int atlasID, ResourceKey<Level> world, List<TileGroup> tileGroups) {
        this.m_130130_(atlasID);
        this.m_130085_(world.m_135782_());
        this.m_130130_(tileGroups.size());
        for (TileGroup tileGroup : tileGroups) {
            this.m_130079_(tileGroup.writeToNBT(new CompoundTag()));
        }
    }

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void apply(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int atlasID = buf.m_130242_();
        ResourceKey world = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)buf.m_130281_());
        int length = buf.m_130242_();
        ArrayList<TileGroup> tileGroups = new ArrayList<TileGroup>(length);
        for (int i = 0; i < length; ++i) {
            CompoundTag tag = buf.m_130260_();
            if (tag == null) continue;
            tileGroups.add(TileGroup.fromNBT(tag));
        }
        context.queue(() -> {
            AtlasData atlasData = AntiqueAtlasMod.tileData.getData(atlasID, context.getPlayer().m_20193_());
            WorldData worldData = atlasData.getWorldData((ResourceKey<Level>)world);
            for (TileGroup t : tileGroups) {
                worldData.putTileGroup(t);
            }
        });
    }
}

